/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.platform.nxt.I2CSensor;
import icommand.platform.nxt.Sensor;

public class Compass
extends I2CSensor {
    private static final byte AUTO_TRIG_ON = 65;
    private static final byte AUTO_TRIG_OFF = 83;
    private static final byte BYTE_MODE = 66;
    private static final byte INTEGER_MODE = 73;
    public static final byte USA_MODE = 85;
    public static final byte EU_MODE = 69;
    private static final byte ADPA_ON = 78;
    private static final byte ADPA_OFF = 79;
    private static final byte BEGIN_CALIBRATION = 67;
    private static final byte END_CALIBRATION = 68;
    private static final byte LOAD_USER_CALIBRATION = 76;
    private static final byte COMMAND = 65;
    private static final byte HEADING_LSB = 66;
    private static final byte HEADING_MSB = 67;

    public Compass(Sensor sensor) {
        super(sensor, (byte)11);
        this.setRegion((byte)85);
        super.setData((byte)65, (byte)73);
    }

    public void setRegion(byte by) {
        super.setData((byte)65, by);
    }

    public void startCalibration() {
        super.setData((byte)65, (byte)67);
    }

    public void stopCalibration() {
        super.setData((byte)65, (byte)68);
    }

    public double getRadians() {
        return this.getDegrees() / 360.0 * 2.0 * Math.PI;
    }

    public double getDegrees() {
        byte[] byArray = this.getData((byte)66, 2);
        int n = 0xFF & byArray[0] | (0xFF & byArray[1]) << 8;
        double d = (double)n / 10.0;
        return d;
    }

    protected byte[] getData(byte by, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = super.getData((byte)(by + i), 1)[0];
        }
        return byArray;
    }
}

