/*
 * Decompiled with CFR 0.152.
 */
package icommand.nxtcomm;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import icommand.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NXTComm {
    static CommPort commPort;
    static InputStream in;
    static OutputStream out;
    static final int SERIAL_TIMEOUT = 2000;
    static final int BLUETOOTH_BAUD = 460800;

    private NXTComm() {
    }

    static void open() throws Exception {
        String string = Properties.getNxtComm();
        System.out.println("NXTCOMM = " + string);
        if (string == null) {
            throw new Exception("NXTCOMM is not defined as a system Environment Variable");
        }
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
        if (commPortIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
            throw new PortInUseException();
        }
        commPort = commPortIdentifier.open("Bluetooth " + string, 2000);
        if (!(commPort instanceof SerialPort)) {
            System.out.println("Error: " + string + " is not a serial port.");
            throw new NoSuchPortException();
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(460800, 8, 1, 0);
        serialPort.setRTS(true);
        serialPort.setDTR(true);
        in = serialPort.getInputStream();
        out = serialPort.getOutputStream();
    }

    public static synchronized byte[] readData() {
        byte[] byArray = null;
        int n = -1;
        try {
            while ((n = in.read()) < 0) {
            }
            int n2 = in.read();
            n = 0xFF & n | (0xFF & n2) << 8;
            byArray = new byte[n];
            in.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public static synchronized void sendData(byte[] byArray) {
        int n = byArray.length;
        int n2 = byArray.length >>> 8;
        try {
            out.write((byte)n);
            out.write((byte)n2);
            out.write(byArray);
        }
        catch (IOException iOException) {
            System.out.println("Error encountered in NXTComm.sendData()");
            iOException.printStackTrace();
        }
    }

    public static void close() {
        try {
            in.close();
            out.close();
            commPort.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

