{************************************************
 * PrepareFpcNasmfiles				*
 *						*
 * strips EXTERNALs from NASM files		*
 *						*
 * written by Bastian Gloeckle,	programmer of	*
 * nucleOS					*
 ************************************************}
program pfn;
uses crt, sysutils, pfn_types;

var	Parameters	: TParameters;

const version='v1.0b1';


{********************************************************
 * function GetParameters:TParameters;			*
 *							*
 * gets all parameters passed to SE and	saves		*
 * them in a TParameters structure			*
 ********************************************************}
function GetParameters:TParameters;
var	iCnt	: integer;
	sHelp	: string;
begin
  GetParameters.bHelp		:= false;
  GetParameters.bBits32		:= true;
  GetParameters.bJump		:= true;
  GetParameters.sEntry		:= 'PASCALMAIN';
  GetParameters.sInput		:= '';
  GetParameters.sOutput		:= 'out.s';
  GetParameters.iUnitsCnt	:= 0;
  GetParameters.sTempfile	:= 'pfn.tmp';
  GetParameters.sUnitPath	:= '';
  GetParameters.sUnitExtension	:= 's';
  if paramcount=0 then exit;	{ if no parameters have been passed }
  iCnt:=0;
  while (iCnt<paramcount) do
  begin
    inc(iCnt);
    sHelp:=paramstr(iCnt);
    if sHelp[1]<>'-' then	{ is parameter = input file? }
    begin
      GetParameters.sInput:=copy(sHelp,1,length(sHelp));
    end else
    begin
      case sHelp[2] of		{ check character after "-" }
        'o': GetParameters.sOutput	:=copy(sHelp,3,length(sHelp));
	'h': GetParameters.bHelp	:=true;
	'b': GetParameters.bBits32	:=false;
	'e': GetParameters.sEntry	:=copy(sHelp,3,length(sHelp));
	'j': GetParameters.bJump	:=false;
	'a': begin
	       inc(GetParameters.iUnitsCnt);
	       GetParameters.aUnits[GetParameters.iUnitsCnt]:=Upcase(copy(sHelp,3,length(sHelp)));
	     end;
        't': GetParameters.sTempfile	:=copy(sHelp,3,length(sHelp));
        'u': begin
	       GetParameters.sUnitPath	:=copy(sHelp,3,length(sHelp));
	       if GetParameters.sUnitPath[length(GetParameters.sUnitPath)]<>'\' then	{ make sure there is a trailing \ }
	         GetParameters.sUnitPath:=GetParameters.sUnitPath+'\';
	     end;
        'f': GetParameters.sUnitExtension:=copy(sHelp,3,length(sHelp));
      end;
    end;
  end;
end;

{********************************************************
 * procedure Proceed(Parameters:TParameters)		*
 *							*
 * does the main work					*
 ********************************************************}
procedure Proceed(Parameters:TParameters);
var	tFileSHndl	: textfile;	{ Sourcefile handle }
	tFileDHndl	: textfile;	{ Destinationfile handle }
	tFileTHndl	: textfile;	{ temporary file handle }
	sBuf		: string;
	sBuf2		: string;
begin
  assign(tFileSHndl,Parameters.sInput);	{ open files }
  reset(tFileSHndl);
  assign(tFileDHndl,Parameters.sOutput);
  rewrite(tFileDHndl);
  if Parameters.bJump then
    writeln(tFileDHndl,'JMP '+Parameters.sEntry);	{ set the jump to the entry point }
  while (not Eof(tFileSHndl)) do
  begin
    readln(tFileSHndl,sBuf);
    if (trim(sBuf)='BITS 32') and (Parameters.bBits32) then 
      readln(tFileSHndl,sBuf);				{ delete "BITS 32" line if user wants to }
    while (Upcase(copy(sBuf,0,6))='EXTERN') do		{ skip all the EXTERNs (they are in the temp file) }
    begin
      readln(tFileSHndl,sBuf);
    end;
    if (trim(sBuf)='GLOBAL _main') then			{ print temp file before "GLOBAL _main" }
    begin
      writeln(tFileDHndl,'; PFN START');
      assign(tFileTHndl,Parameters.sTempfile);
      reset(tFileTHndl);
      while (not Eof(tFileTHndl)) do
      begin
        readln(tFileTHndl,sBuf2);
	writeln(tFileDHndl,sBuf2);
      end;
      close(tFileTHndl);
      DeleteFile(Parameters.sTempfile);
      writeln(tFileDHndl,'; PFN END');
    end;
    writeln(tFileDHndl,sBuf);
  end;
  close(tFileSHndl);
  close(tFileDHndl);
end;

{********************************************************
 * procedure PrepareUnits(Parameters:TParameters)	*
 *							*
 * generates the (temporary) file, that includes the	*
 * NASM source lines, which must be added before	*
 * "GLOBAL _main"					*
 ********************************************************}
procedure PrepareUnits(Parameters:TParameters);
var	tFileMHndl	: textfile;	{ main file }
	tFileDHndl	: textfile;	{ the destination file (temp file) }
	tFileSHndl	: textfile;	{ the source file(s) (the various units) }
	sBuf		: string;	{ some buffer }
	sBuf2		: string;
	bFound		: boolean;	{ is label found (in unit)? }
	bDel		: boolean;	{ should teh label be "ret"ed? }
	sHelp		: string;
	iCnt		: integer;
begin
  assign(tFileMHndl,Parameters.sInput);	{ open files }
  reset(tFileMHndl);
  assign(tFileDHndl,Parameters.sTempfile);
  rewrite(tFileDHndl);

  while (not Eof(tFileMHndl)) do			{ read complete file and work on all the EXTERNALs }
  begin
    readln(tFileMHndl,sBuf);				{ sBuf = whole line in main file }
    if (Upcase(copy(sBuf,0,6))='EXTERN') then
    begin
      bDel := true;
      iCnt := 1;
      sHelp:=trim(copy(sBuf,8,length(sBuf)));		{ sHelp = unit name from the EXTERNAL }
      sHelp:= Upcase(copy(sHelp,0,pos('$',sHelp)-1));
      while (iCnt <= Parameters.iUnitsCnt) do
      begin
        if ('_'+Parameters.aUnits[iCnt]=sHelp) then	{ if we should work on this unit (-a parameter)... }
	begin
	  bDel := false;
	  sBuf2:=Parameters.sUnitPath+Parameters.aUnits[iCnt]+'.'+Parameters.sUnitExtension;	{ sBuf2 = whole path to unit }
	  writeln(tFileDHndl,'; code from unit '+sBuf2+' starts');
	  writeln('Processing unit: '+sBuf2+' (searching for '+copy(sBuf,8,length(sBuf))+')');
	  assign(tFileSHndl,sBuf2);
	  reset(tFileSHndl);
          while (not Eof(tFileSHndl)) do		{ search for our needed label }
	  begin
	    readln(tFileSHndl,sBuf2);			{ sBuf2 = actual line on unit }
	    bFound:=false;
	    if trim(sBuf2)='GLOBAL '+copy(sBuf,8,length(sBuf)) then
	    begin
	      bFound:=true;				{ label found :) }
	      break;
	    end;
	  end;
	  while (bFound) do				{ write everthing after the label until an "ALIGN" is found into the tempfile }
	  begin
            writeln(tFileDHndl,sBuf2);
	    if Eof(tFileSHndl) then break;
	    if (Upcase(copy(trim(sBuf2),0,5))='ALIGN') then break;
	    readln(tFileSHndl,sBuf2);
	  end;
	  if (not bFound) then bDel:=true;		{ if we did not find the label, we "ret" it }
	  close(tFileSHndl);
	  writeln(tFileDHndl,'; code from unit '+Parameters.sUnitPath+Parameters.aUnits[iCnt]+'.'+Parameters.sUnitExtension+' ends');
	  break;
	end;
	inc(iCnt);
      end;
      if bDel then 
        writeln(tFileDHndl,copy(sBuf,8,length(sBuf))+': ret');	{ "ret" the label }
    end;
  end;
  close(tFileMHndl);
  close(tFileDHndl);
end;

{********************************************************
 * procedure ShowHelp					*
 *							*
 * displays the help					*
 ********************************************************}
procedure ShowHelp;
begin
  writeln('Change a FPC generated NASM file so that it can be assembeled to a flat binary');
  writeln('written for FPC v1.0.10 and NASM v0.98.36');
  writeln('');
  writeln('Usage: pfn [options] [file]');
  writeln('');
  writeln('Options:');
  writeln('         -a<unit>  use these units (max. 100)');
  writeln('         -b        do NOT delete the "BITS 32" line');
  writeln('         -e<entry> set the entry point of the file (standard: "PASCALMAIN")');
  writeln('         -f<ext>   set fileextension of units to .<ext> (standard: "s")');
  writeln('         -j        do NOT add the jump to <entry> at the beginning of the file');
  writeln('         -o<file>  set output to <file> (standard: "out.s")');
  writeln('         -t<file>  use <file> as temporary file (standard: "pfn.tmp")');
  writeln('         -u<path>  use <path> to look for units (standard: empty)');
  writeln('File:');
  writeln('         the input file');
  writeln('');
end;

{********************************************************
 * MAIN PROGRAM						*
 ********************************************************}

begin
  Parameters:=GetParameters;
  writeln('PrepareFpcNasmfile '+version+', written by Bastian Gloeckle (nucleOS group)');
  if Parameters.bHelp or (paramcount=0) then				{ Show help? }
  begin
    ShowHelp;
    exit;
  end;
  if not fileExists(Parameters.sInput) then
  begin
    writeln('ERROR: input file does not exist!');
    exit;
  end;
  writeln('');
  writeln('Processing: '+Parameters.sInput);
  PrepareUnits(Parameters);
  Proceed(Parameters);
end.
